% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-layers.R
\name{layer_independent_normal}
\alias{layer_independent_normal}
\title{An independent Normal Keras layer.}
\usage{
layer_independent_normal(
  object,
  event_shape,
  convert_to_tensor_fn = tfp$distributions$Distribution$sample,
  validate_args = FALSE,
  ...
)
}
\arguments{
\item{object}{Model or layer object}

\item{event_shape}{Scalar integer representing the size of single draw from this distribution.}

\item{convert_to_tensor_fn}{A callable that takes a tfd$Distribution instance and returns a
tf$Tensor-like object. Default value: \code{tfd$distributions$Distribution$sample}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.
@param ... Additional arguments passed to \code{args} of \code{keras::create_layer}.}

\item{...}{Additional arguments passed to \code{args} of \code{keras::create_layer}.}
}
\value{
a Keras layer
}
\description{
An independent Normal Keras layer.
}
\examples{
\donttest{
library(keras)
input_shape <- c(28, 28, 1)
encoded_shape <- 2
n <- 2
model <- keras_model_sequential(
  list(
    layer_input(shape = input_shape),
    layer_flatten(),
    layer_dense(units = n),
    layer_dense(units = params_size_independent_normal(encoded_shape)),
    layer_independent_normal(event_shape = encoded_shape)
    )
  )
}
}
\seealso{
Other distribution_layers: 
\code{\link{layer_categorical_mixture_of_one_hot_categorical}()},
\code{\link{layer_distribution_lambda}()},
\code{\link{layer_independent_bernoulli}()},
\code{\link{layer_independent_logistic}()},
\code{\link{layer_independent_poisson}()},
\code{\link{layer_kl_divergence_add_loss}()},
\code{\link{layer_kl_divergence_regularizer}()},
\code{\link{layer_mixture_logistic}()},
\code{\link{layer_mixture_normal}()},
\code{\link{layer_mixture_same_family}()},
\code{\link{layer_multivariate_normal_tri_l}()},
\code{\link{layer_one_hot_categorical}()}
}
\concept{distribution_layers}
