% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_pert}
\alias{tfd_pert}
\title{Modified PERT distribution for modeling expert predictions.}
\usage{
tfd_pert(
  low,
  peak,
  high,
  temperature = 4,
  validate_args = FALSE,
  allow_nan_stats = FALSE,
  name = "Pert"
)
}
\arguments{
\item{low}{lower bound}

\item{peak}{most frequent value}

\item{high}{upper bound}

\item{temperature}{controls the shape of the distribution}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The PERT distribution is a loc-scale family of Beta distributions
fit onto a real interval between \code{low} and \code{high} values set by the user,
along with a \code{peak} to indicate the expert's most frequent prediction,
and \code{temperature} to control how sharp the peak is.
}
\details{
The distribution is similar to a \href{https://en.wikipedia.org/wiki/Triangular_distribution}{Triangular distribution}
(i.e. \code{tfd.Triangular}) but with a smooth peak.

Mathematical Details

In terms of a Beta distribution, PERT can be expressed as\preformatted{PERT ~ loc + scale * Beta(concentration1, concentration0)
}

where\preformatted{loc = low
scale = high - low
concentration1 = 1 + temperature * (peak - low)/(high - low)
concentration0 = 1 + temperature * (high - peak)/(high - low)
temperature > 0
}

The support is \verb{[low, high]}.  The \code{peak} must fit in that interval:
\verb{low < peak < high}.  The \code{temperature} is a positive parameter that
controls the shape of the distribution. Higher values yield a sharper peak.
The standard PERT distribution is obtained when \code{temperature = 4}.
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.
}
