% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_card.R
\name{prep_combine_vars}
\alias{prep_combine_vars}
\title{Combine variables}
\usage{
prep_combine_vars(df, vars, remove = TRUE)
}
\arguments{
\item{df}{(data.frame)}

\item{vars}{(character) a vector of variables to unite. If a single variable
is supplied, the input is returned unchanged.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}
}
\value{
a data.frame with an additional column, called \code{variable_level} or
the input unchanged.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A wrapper around \code{tidyr::unite()} which pastes several columns into one.
In addition it checks the output is identical to \code{dplyr::coalesce()}. If not
identical, the input data.frame is returned unchanged. Useful for uniting
sparsely populated columns, for example when processing an ard that was
created with \code{\link[cards:ard_stack]{cards::ard_stack()}} then shuffled with \verb{[shuffle_card()]}.

If the data is the result of a hierarchical ard stack (with
\code{\link[cards:ard_stack_hierarchical]{cards::ard_stack_hierarchical()}} or
\code{\link[cards:ard_stack_hierarchical]{cards::ard_stack_hierarchical_count()}}), the input is returned unchanged.
This is assessed from the information in the \code{context} column which needs to
be present. If the input data does not have a \code{context} column, the input
will be returned unmodified.
}
\examples{
df <- data.frame(
  a = 1:6,
  context = rep("categorical", 6),
  b = c("a", rep(NA, 5)),
  c = c(NA, "b", rep(NA, 4)),
  d = c(NA, NA, "c", rep(NA, 3)),
  e = c(NA, NA, NA, "d", rep(NA, 2)),
  f = c(NA, NA, NA, NA, "e", NA),
  g = c(rep(NA, 5), "f")
)

prep_combine_vars(
  df,
  vars = c("b", "c", "d", "e", "f", "g")
)
}
