% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_metadata.R
\name{write_run_metadata}
\alias{write_run_metadata}
\alias{write_run_data}
\title{Write run metadata into the current run directory}
\usage{
write_run_metadata(type, data)

write_run_data(type, data)
}
\arguments{
\item{type}{Type of metadata to write. Standard types include "flags",
"sources", "properties", "metrics", and "evaluation". You can
also specify a custom type (see \emph{Custom Types} section below).}

\item{data}{Metadata to write:
\itemize{
\item "flags" --- Named list of training flags
\item "source" --- Directory to copy source files from
\item "properties" --- Named list of arbitrary properties. Note
that properties will be stored as strings.
\item "metrics" --- Data frame with training run metrics
(see \emph{Metrics Data Frame} below).
\item "evaluation" --- Named list of evaluation metrics.
\item "<custom>" -- Function used to write the data
(see \emph{Custom Types} section below).
}}
}
\description{
Record various types of training run metadata This function can be called
even when a run directory isn't active (metadata will only be written if
and when a run directory is initialized).
}
\note{
\code{write_run_data()} is deprecated and is provided as an alias
for backward compatibility.
}
\section{Metrics Data Frame}{


Metrics should be passed as a data frame with one column for each metric.
If the metrics are not yet complete (e.g. only metrics for the
first several epochs are provided) then metrics in yet to be completed
epochs should use \code{NA} as their values. For example:\preformatted{data.frame':	30 obs. of  4 variables:
$ loss    : num  0.423 0.201 NA NA NA ...
$ acc     : num  0.873 0.942 NA NA NA ...
$ val_loss: num  0.174 0.121 NA NA NA ...
$ val_acc : num  0.949 0.964 NA NA NA ...
}

If both metrics and validation metrics are provided, you should preface the
name of the validation metric with \code{"val_"} (e.g. for a metric named \code{"loss"}
provide validation metrics in \code{"val_loss"}). This indicates that the metrics
are related which is useful e.g. when plotting metrics.
}

\section{Custom Types}{


You can pass a type with an arbitary name along with a function that
should be used to writes the data. The function will be passed a
single \code{data_dir} argument. For example:\preformatted{write_run_metadata("images", function(data_dir) {
  # write into data_dir here
})
}
}

\keyword{internal}
