% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tribble.R
\name{frame_matrix}
\alias{frame_matrix}
\title{Row-wise matrix creation}
\usage{
frame_matrix(...)
}
\arguments{
\item{...}{Arguments specifying the structure of a \code{frame_matrix}.
Column names should be formulas, and may only appear before the
data. These arguments support \link[rlang:tidy-dots]{tidy dots}.}
}
\value{
A \link{matrix}.
}
\description{
\Sexpr[results=rd, stage=render]{tibble:::lifecycle("maturing")}

Create matrices laying out the data in rows, similar to
\code{matrix(..., byrow = TRUE)}, with a nicer-to-read syntax.
This is useful for small matrices, e.g. covariance matrices, where readability
is important. The syntax is inspired by \code{\link[=tribble]{tribble()}}.
}
\examples{
frame_matrix(
  ~col1, ~col2,
  1,     3,
  5,     2
)
}
