% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_kable.R
\name{to_kable}
\alias{to_kable}
\title{Pass tibble_one to kable}
\usage{
to_kable(object, use_groups = TRUE, indent_groups = FALSE,
  footnote_notation = "symbol", include_1st_header = TRUE,
  include_2nd_header = TRUE, include_3rd_header = TRUE,
  bold_headers = TRUE, ...)
}
\arguments{
\item{object}{a tibble_one object}

\item{use_groups}{T/F, should rows be grouped?}

\item{indent_groups}{T/F, should entries within groups be indented?
(this has no effect if \code{use_groups} is \code{FALSE})}

\item{footnote_notation}{character value indicating footnote symbols to
use in tables. Eligible values are \code{symbol}, \code{number}, and \code{alphabet}.}

\item{include_1st_header}{T/F, should bottom header be included?}

\item{include_2nd_header}{T/F, should middle header be included?}

\item{include_3rd_header}{T/F, should top header be included?}

\item{bold_headers}{T/F, should header labels be printed in bold?}

\item{...}{Arguments passed on to \code{knitr::kable}
\describe{
  \item{format}{A character string. Possible values are \code{latex},
\code{html}, \code{markdown}, \code{pandoc}, and \code{rst}; this will be
automatically determined if the function is called within \pkg{knitr}; it
can also be set in the global option \code{knitr.table.format}. If
\code{format} is a function, it must return a character string.}
  \item{caption}{The table caption.}
  \item{label}{The table reference label. By default, the label is obtained
from \code{knitr::\link{opts_current}$get('label')}.}
}}
}
\value{
A character vector of the table source code, i.e., code that can
be presented in 'R Markdown' documents.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("stable")}

Tabular summaries of characteristics (i.e., table one) are generally
presented in a table with columns that describe the overall sample
and subsets of the sample designated by a grouping variable.
In addition, it is expected that variable labels and units will be
indicated, and footnotes will be placed at the bottom of the table
with full descriptions of variables and abbreviations that appear
in the table. This function automates these tasks.
}
