% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_summarise.R
\name{time_summarise}
\alias{time_summarise}
\alias{time_summarize}
\title{Summarise a \code{tbl_time} by period}
\usage{
time_summarise(.data, period = "yearly", ...)

time_summarize(.data, period = "yearly", ...)
}
\arguments{
\item{.data}{A \code{tbl_time} object.}

\item{period}{A period to summarise by.}

\item{...}{Name-value pairs of summary functions. The name will be the
name of the variable in the result. The value should be an expression
that returns a single value like \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.

These arguments are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. They support \link[rlang:quasiquotation]{unquoting} and
splicing. See \code{vignette("programming")} for an introduction to
these concepts.}
}
\description{
\code{\link[=time_summarise]{time_summarise()}} works similarly to \code{\link[dplyr:summarise]{dplyr::summarise()}} but with the added
benefit of being able to summarise by a time period such as \code{"yearly"} or
\code{"monthly"}.
}
\details{
Groups applied using \code{\link[dplyr:group_by]{dplyr::group_by()}} are respected.

In \code{\link[dplyr:summarise]{dplyr::summarise()}}, one level of grouping is usually removed.
Because an added group for the time index is added in \code{time_summarise},
none of the original groups are removed.
}
\note{
The following periods are available:
\itemize{
\item \code{"yearly"}
\item \code{"quarterly"}
\item \code{"monthly"}
\item \code{"weekly"}
\item \code{"daily"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
}
}
\examples{

# Basic functionality -------------------------------------------------------

data(FB)
FB <- as_tbl_time(FB, date)

# Calculate the mean and standard deviation of the adjusted column
# at a yearly interval
FB \%>\%
  time_summarise(period = "yearly",
                 adj_mean = mean(adjusted),
                 adj_sd   = sd(adjusted))

# Want a more granular view? Look at monthly instead
FB \%>\%
  time_summarise(period = "monthly",
                 adj_mean = mean(adjusted),
                 adj_sd   = sd(adjusted))

# Grouped functionality -----------------------------------------------------

data(FANG)
FANG <- as_tbl_time(FANG, date) \%>\%
  dplyr::group_by(symbol)

# Groups are respected, allowing for very useful summaries
# grouped by symbol and by time period
FANG \%>\%
  time_summarise(period = "yearly",
                 vol_max   = max(volume),
                 vol_min   = min(volume),
                 # Like summarise, you can use columns you just computed
                 vol_range = vol_max - vol_min)


}
