% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_corr_test.R
\name{bf_corr_test}
\alias{bf_corr_test}
\title{Bayesian correlation test.}
\usage{
bf_corr_test(
  data,
  x,
  y,
  bf.prior = 0.707,
  caption = NULL,
  output = "results",
  hypothesis.text = TRUE,
  k = 2,
  ...
)
}
\arguments{
\item{data}{for use with \code{formula}, a data frame containing all the
data}

\item{x}{The column in \code{data} containing the explanatory variable to be
plotted on the \code{x}-axis. Can be entered either as a character string (e.g.,
\code{"x"}) or as a bare expression (e.g, \code{x}).}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis. Can be entered either as a character string
(e.g., \code{"y"}) or as a bare expression (e.g, \code{y}).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{caption}{Text to display as caption (will be displayed on top of the
Bayes Factor caption/message).}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"} or \code{"h0"}),
which will return expression with evidence in favor of the null hypothesis,
or \code{"alternative"} (or \code{"title"} or \code{"H1"} or \code{"h1"}), which will return
expression with evidence in favor of the alternative hypothesis, or
\code{"results"}, which will return a dataframe with results all the details).}

\item{hypothesis.text}{Logical that decides whether the expression containing
result should have text to describe the hypothesis test being described.
For \code{output = "null"}, this is \code{"In favor of null: "}, otherwise
\code{"In favor of alternative: "}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (ignored).}
}
\description{
Bayesian correlation test.
}
\examples{
# for reproducibility
set.seed(123)

# to see results
bf_corr_test(
  data = anscombe,
  x = x1,
  y = y4,
  bf.prior = 1
)

# to get caption
bf_corr_test(
  data = anscombe,
  x = x1,
  y = y4,
  bf.prior = 0.8,
  output = "null"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_oneway_anova}},
\code{\link{bf_ttest}}
}
