% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalogs.R
\encoding{UTF-8}
\name{bde_catalog_search}
\alias{bde_catalog_search}
\title{Search BdE catalogs}
\usage{
bde_catalog_search(pattern, ...)
}
\arguments{
\item{pattern}{regex pattern to search See Details and Examples.}

\item{...}{
  Arguments passed on to \code{\link[=bde_catalog_load]{bde_catalog_load}}
  \describe{
    \item{\code{catalog}}{A single value indicating the catalogs to be updated
or "ALL" as a shorthand. See Details}
    \item{\code{parse_dates}}{Logical. If TRUE the dates would be parsed using
\code{\link[=bde_parse_dates]{bde_parse_dates()}}.}
    \item{\code{update_cache}}{Logical. If TRUE the requested file would be updated on
the \code{cache_dir}.}
    \item{\code{cache_dir}}{A path to a cache directory. The directory can also be set
via options with \code{options(bde_cache_dir = "path/to/dir")}.}
    \item{\code{verbose}}{Logical, display information useful for debugging.}
  }}
}
\value{
A tibble with the results of the query.
}
\description{
Search for keywords on the time-series catalogs.
}
\details{
\strong{Note that} BdE files are only provided in
Spanish, for the time being. Therefore search terms should be provided
in Spanish as well in order to get search results.

This function uses \code{\link[base:grep]{grep()}} function for finding matches on
the catalogs. You can pass \link[base:grep]{regular expressions} to broaden
the search.
}
\examples{
\donttest{
# Simple search (needs to be in Spanish)
# !! PIB [es] == GDP [en]

PIB <- bde_catalog_search("PIB", catalog = "IE")

names(PIB)[c(2, 3, 5)]

PIB[c(2, 3, 5)]

# More complex - Single
FRA_PIB <- bde_catalog_search("Francia(.*)PIB", catalog = "IE")

FRA_PIB[c(2, 3, 5)]

# Even more complex - Double
FRA_ITA_DEU_PIB <-
  bde_catalog_search("Francia(.*)PIB|Italia(.*)PIB|Alemania(.*)PIB",
    catalog = "IE"
  )

FRA_ITA_DEU_PIB[c(2, 3, 5)]

# Search an alias: Exact match
bde_catalog_search("^IE_1_1.1$")[c(2, 3, 5)]

# Search a sequential code: Exact match
# Note that this series (sequential code) appears on several tables

bde_catalog_search("^3779313$")[c(2, 3, 5)]
}
}
\seealso{
\code{\link[=bde_catalog_load]{bde_catalog_load()}}, \code{\link[base:grep]{grep()}}
}
\concept{catalog}
