% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_mods.R
\name{bb_mods}
\alias{bb_mods}
\title{Fit beta binomial models to each taxa within an OTU table}
\usage{
bb_mods(
  micro_set,
  table,
  ...,
  CI_method = c("wald", "profile"),
  SS_type = c(2, 3, "II", "III"),
  trace = FALSE
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{...}{Covariates of interest. Can be interactions such as Group*Age}

\item{CI_method}{Character indicating the type of method used for confidence interval estimation. Wald intervals are the current default. Abbreviations allowed. See \code{\link[VGAM]{confintvglm}} for more details}

\item{SS_type}{Type of sums of squares calculated in \code{\link[VGAM]{anova.vglm}}. Either type II (2) or type III (3) sums of squares. Type II is the default}

\item{trace}{Print messages of model fitting proceedure}
}
\value{
A list containing several different model components and summaries
\item{Convergend_Summary}{A data.frame of model summaries from convergent models. Includes the Taxa name, the model coefficient, the estimated beta, the beta's 95 percent confidence interval, Z score, p_value, false discovery rate p-value, and p-value from likelihood ratio test}
\item{Estimate_Summary}{A data.frame of model estimates from convergent models intended to be ready for export for publications. Includes the Taxa name, the model coefficient, the estimated Rate Ratio, the Wald 95 percent confidence interval, the Z-score, and false discovery rate p-value}
\item{RA_Summary}{A data.frame of taxa summaries. Includes the Taxa name, grouping variables (each factor variable in your models), sample size (n), percent of 0 counts, basic summaries of relative abundance, percentiles of relative abundance, and a logical indicator of whether or not the model converged}
\item{formula}{The formula used in the model}
\item{Model_Coef}{Model coefficients (used in plotting funcitons)}
\item{Model_Covs}{Model covariates (used in plotting functions)}
}
\description{
Fit beta binomial models to each taxa within an OTU table through \code{\link[VGAM]{vglm}} in the \pkg{VGAM} package. Summaries for models or confidence intervals that fail to converge will not be returned, but taxa summaries will be provided in the output. Rank-Sum tests or presence/absence tests can be run on these taxa using \code{tidi_rank_sum} or \code{tidi_chisq}, respectively
}
\details{
Models containing only fixed effects are fit using \code{\link[VGAM]{vglm}} in the \pkg{VGAM} package. ANOVA / ANCOVA tests are conducted using a Likelihood Ratio test
}
\note{
False Discovery Rate p-values are calculated using \code{\link[stats]{p.adjust}}. Estimated rate ratios and confidence intervals for interactions in the Estimate_Summary table include all main effects. It is not simply the exponentiated interaction beta, it is the interaction of the sum of the intercept, corresponding main effect betas, and interaction betas
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)

otu_tabs <- list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin) \%>\%
  filter(day == 7) ## Only including first week

\donttest{
bb_phy <- set \%>\%

## Filtering out low abundance and unclassified taxa
## These models will either break or we don't care about them
otu_filter(prev_cutoff = 5, ra_cutoff = 0.1,
           exclude_taxa = c("Unclassified", "Bacteria")) \%>\%

## Beta binomial models for each Family of taxa with bpd1 as a covariate
bb_mods(table = "Phylum", bpd1, CI_method = "wald")

names(bb_phy)
bb_phy$Estimate_Summary
}
}
\references{
\code{\link[VGAM]{anova.vglm}}, \code{\link[VGAM]{vglm}}, \code{\link[VGAM]{betabinomial}}
}
