% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_outputs}
\alias{parse_outputs}
\title{Parse the outputs of the CWL workflow into a data frame}
\usage{
parse_outputs(x, simplify = TRUE)
}
\arguments{
\item{x}{CWL object}

\item{simplify}{Simplify the list as a data frame?}
}
\value{
List or data frame of outputs
}
\description{
Parse the outputs of the CWL workflow into a data frame
}
\examples{
system.file("cwl/sbg/workflow/rnaseq-salmon.json", package = "tidycwl") \%>\%
  read_cwl_json() \%>\%
  parse_outputs() \%>\%
  names()

system.file("cwl/sbg/workflow/rnaseq-salmon.cwl", package = "tidycwl") \%>\%
  read_cwl_yaml() \%>\%
  parse_outputs() \%>\%
  names()
}
