% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.svm.R
\name{.model.svm}
\alias{.model.svm}
\title{Support vector regression or classification for \code{tidyfit}}
\usage{
\method{.model}{svm}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a support vector regression or classification on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} or \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}
\itemize{
\item cost (\emph{cost of constraint violation})
\item epsilon (\emph{epsilon in the insensitive-loss function})
}

\strong{Important method arguments (passed to \code{\link{m}})}

The function provides a wrapper for \code{e1071::svm}. See \code{?svm} for more details.

\strong{Implementation}

The default value for the \code{kernel} argument is set to 'linear'. If set to a different value, no coefficients will be returned.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::filter(data, Industry == "HiTec")

# Stand-alone function
fit <- m("svm", Return ~ `Mkt-RF` + HML + SMB, data, cost = 0.1)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("svm", cost = 0.1),
               .mask = c("Date", "Industry"))
coef(fit)

}
\references{
Meyer D, Dimitriadou E, Hornik K, Weingessel A, Leisch F (2022).
\emph{e1071: Misc Functions of the Department of Statistics, Probability Theory Group (Formerly: E1071), TU Wien}.
R package version 1.7-12, \url{https://CRAN.R-project.org/package=e1071}.
}
\seealso{
\code{\link{.model.boost}}, \code{\link{.model.lasso}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
