% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topn_dt.R
\name{top_dt}
\alias{top_dt}
\alias{top_n_dt}
\alias{top_frac_dt}
\title{Select top (or bottom) n rows (by value)}
\usage{
top_dt(.data, wt = NULL, n = NULL, prop = NULL)

top_n_dt(.data, n, wt = NULL)

top_frac_dt(.data, prop, wt = NULL)
}
\arguments{
\item{.data}{data.frame}

\item{wt}{(Optional). The variable to use for ordering.
If not specified, defaults to the last variable in the data.frame.}

\item{n}{Number of rows to return.
Will include more rows if there are ties.
If \code{n} is positive, selects the top rows.
If negative, select the bottom rows.}

\item{prop}{Fraction of rows to return.
Will include more rows if there are ties.
If \code{prop} is positive, selects the top rows.
If negative, select the bottom rows.}
}
\value{
data.table
}
\description{
Analogous function for \code{top_n} and \code{top_frac} in \pkg{dplyr}, but with a different API.

In \code{top_dt}, you can use an API for both
functionalities in `top_n_dt()` and `top_frac_dt()`.
}
\examples{
iris \%>\% top_n_dt(10,Sepal.Length)
iris \%>\% top_n_dt(-10,Sepal.Length)
iris \%>\% top_frac_dt(.1,Sepal.Length)
iris \%>\% top_frac_dt(-.1,Sepal.Length)

# For `top_dt`, you can use both modes above
iris \%>\% top_dt(Sepal.Length,n = 10)
iris \%>\% top_dt(Sepal.Length,prop = .1)
}
\seealso{
\code{\link[dplyr]{top_n}}
}
