% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_db.R
\name{hy_src}
\alias{hy_src}
\alias{hy_src_disconnect}
\title{Open a connection to the HYDAT database}
\usage{
hy_src(hydat_path = NULL)

hy_src_disconnect(src)
}
\arguments{
\item{hydat_path}{The path to the hydat database or NULL to use the default location
used by \link{download_hydat}. It is also possible to pass in an existing
\link[dplyr]{src_sqlite} such that the database only needs to be opened once per
user-level call.}

\item{src}{A  as returned by \code{\link[=hy_src]{hy_src()}}.}
}
\value{
A SQLite DBIConnection
}
\description{
This function gives low-level access to the underlying HYDAT database used by
other functions. Many of these tables are too large to load into memory,
so it is best to use dplyr to \code{\link[dplyr:filter]{dplyr::filter()}} them before using
\code{\link[dplyr:compute]{dplyr::collect()}} to read them into memory.
}
\examples{
\dontrun{
library(dplyr)

# src is a src_sqlite
src <- hy_src(hydat_path = hy_test_db())
src_tbls(src)

# to get a table, use dplyr::tbl()
tbl(src, "STATIONS")

# one you're sure the results are what you want
# get a data.frame using collect()
tbl(src, "STATIONS") \%>\%
  filter(PROV_TERR_STATE_LOC == "BC") \%>\%
  collect()

# close the connection to the database
hy_src_disconnect(src)
}
}
\seealso{
\code{\link[=download_hydat]{download_hydat()}}
}
