% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_ml.R
\name{tx_ml}
\alias{tx_ml}
\title{Subset Clients who Became Inactive (IIT) Within a Given Period}
\usage{
tx_ml(
  old_data = NULL,
  new_data,
  from = NULL,
  to = NULL,
  states = .s,
  facilities = .f,
  status = "calculated"
)
}
\arguments{
\item{old_data}{The initial dataframe containing the list of clients who
were previously active.}

\item{new_data}{The current datafame where changes in current treatment
status will be checked.}

\item{from}{The start date in ISO8601 format (i.e. "yyyy-mm-dd").
The default is to start at the beginning of the current Fiscal Year (i.e. 1st of October).}

\item{to}{The end date written in ISO8601 format (i.e. "yyyy-mm-dd").
The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}
}
\value{
tx_ml
}
\description{
\code{tx_ml} Generates clients who have become inactive over a specified
period of time. The default is to generate all clients who became inactive
in the current Fiscal Year. You can specify the period of interest
(using the \code{from} and \code{to} arguments). Used together
with \code{tx_ml_outcomes()}, generates inactive clients with a particular
outcome of interest.
}
\examples{
tx_ml(new_data = ndr_example)

# Find clients who were inactive at the end of Q1 of FY21
tx_ml(
  new_data = ndr_example,
  to = "2020-12-31"
)

## generate line-list of `tx_ml()` using two datasets
\donttest{
file_path <- "https://raw.githubusercontent.com/stephenbalogun/example_files/main/ndr_example.csv"
ndr_old <- read_ndr(file_path, time_stamp = "2021-02-15")
ndr_new <- ndr_example
tx_ml(
  old_data = ndr_old,
  new_data = ndr_new
)
}
}
