% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cot_cascade.R
\name{cot_cascade}
\alias{cot_cascade}
\title{Analyse the Treatment Continuity Cascade}
\usage{
cot_cascade(
  data,
  quarter = NULL,
  ref = NULL,
  states = NULL,
  facilities = NULL,
  status = "default",
  remove_duplicates = FALSE,
  .level = "state",
  .names = NULL
)
}
\arguments{
\item{data}{An NDR dataframe imported using the \code{read_ndr()}.}

\item{quarter}{the quarter of the fiscal year for which the treatment continuity indicators should be calculated.}

\item{ref}{the referenced date for the analysis. If this is not set (i.e. \code{NULL}) it will be assumed to be the last day of the quarter.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}

\item{remove_duplicates}{Boolean argument. It specifies if duplicate patient entries in the facilities should be removed or kept}

\item{.level}{the level at which the aggregate summary should be performed. The options are "ip", "country", "state", "lga" and "facility".}

\item{.names}{if specified, these will be used for naming of the viral load indicators instead of the default.}
}
\value{
summary of treatment continuity indicators
}
\description{
Generate aggregate summary of treatment continuity indicators based on a specified quarter. The indicators include
\code{tx_curr} (previous quarter), \code{tx_new}, \code{tx_ml}, \code{tx_ml_dead}, \code{tx_ml_to}, \code{tx_ml_iit}, and \code{iit_rate}.
}
\examples{
cot_cascade(ndr_example, quarter = 2, ref = "2022-02-28", .level = "state")

# Determine the treatment continuity cascade for a state at the end of quarter one of FY22
cot_cascade(ndr_example,
  quarter = 1,
  states = "Arewa"
)

}
