% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-misc.R
\name{add_curve_fit}
\alias{add_curve_fit}
\title{Add curve fit}
\usage{
add_curve_fit(
  plot,
  dodge_width = NULL,
  method = "loess",
  linewidth = 0.25,
  alpha = 0.4,
  preserve = "total",
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults
to \code{0.8} for plots with at least one discrete axis and \code{0} for plots with two
continuous axes.}

\item{method}{Smoothing method (function) to use, accepts either
\code{NULL} or a character vector, e.g. \code{"lm"}, \code{"glm"}, \code{"gam"}, \code{"loess"}
or a function, e.g. \code{MASS::rlm} or \code{mgcv::gam}, \code{stats::lm}, or \code{stats::loess}.
\code{"auto"} is also accepted for backwards compatibility.  It is equivalent to
\code{NULL}.

For \code{method = NULL} the smoothing method is chosen based on the
size of the largest group (across all panels). \code{\link[stats:loess]{stats::loess()}} is
used for less than 1,000 observations; otherwise \code{\link[mgcv:gam]{mgcv::gam()}} is
used with \code{formula = y ~ s(x, bs = "cs")} with \code{method = "REML"}. Somewhat anecdotally,
\code{loess} gives a better appearance, but is \eqn{O(N^{2})}{O(N^2)} in memory,
so does not work for larger datasets.

If you have fewer than 1,000 observations but want to use the same \code{gam()}
model that \code{method = NULL} would use, then set
\verb{method = "gam", formula = y ~ s(x, bs = "cs")}.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{alpha}{A \code{number} between \code{0} and \code{1} for the opacity of an object. A value of \code{0} is completely transparent, \code{1} is completely opaque.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{...}{Arguments passed on to \code{ggplot2::geom_smooth()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add curve fit
}
\examples{
time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_curve_fit()

# Changing arguments
time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_curve_fit(linewidth = 1)

time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_curve_fit(alpha = 0.8)

# Remove confidence interval
time_course \%>\%
  tidyplot(x = day, y = score, color = treatment) \%>\%
  add_curve_fit(se = FALSE)

}
