% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_as_regex_match.R
\name{answer_as_regex_match}
\alias{answer_as_regex_match}
\title{Make LLM answer match a specific regex}
\usage{
answer_as_regex_match(prompt, regex, mode = c("full_match", "extract_matches"))
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{regex}{A character string specifying the regular expression the response must match}

\item{mode}{A character string specifying the mode of the regex match. Options are
"exact_match" (default) and "extract_all_matches".
Under "full_match", the full LLM response must match the regex. If
it does not, the LLM will be sent feedback to retry. The full LLM response
will be returned if the regex is matched.
Under "extract_matches", all matches of the regex in the LLM response will be returned
(if present). If the regex is not matched at all, the LLM will be sent feedback to retry.
If there is at least one match, the matches will be returned as a character vector}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which will ensure
that the LLM response matches the specified regex
}
\description{
Make LLM answer match a specific regex
}
\examples{
\dontrun{
  "What would be a suitable e-mail address for cupcake company?" |>
    answer_as_regex_match("^[a-zA-Z0-9._\%+-]+@[a-zA-Z0-9.-]+\\\\.[a-zA-Z]{2,}$") |>
    send_prompt(llm_provider_ollama())
  # --- Sending request to LLM provider (llama3.1:8b): ---
  #   What would be a suitable e-mail address for cupcake company?
  #
  #   You must answer with a response that matches this regex format:
  #     ^[a-zA-Z0-9._\%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$
  #     (use no other characters)
  # --- Receiving response from LLM provider: ---
  #   sweet.treats.cupcakes@gmail.com
  # [1] "sweet.treats.cupcakes@gmail.com"

  "What would be a suitable e-mail address for cupcake company?" |>
    add_text("Give three ideas.") |>
    answer_as_regex_match(
      "[a-zA-Z0-9._\%+-]+@[a-zA-Z0-9.-]+\\\\.[a-zA-Z]{2,}",
      mode = "extract_matches"
    ) |>
    send_prompt(llm_provider_ollama())
  # --- Sending request to LLM provider (llama3.1:8b): ---
  #   What would be a suitable e-mail address for cupcake company?
  #
  #   Give three ideas.
  #
  #   You must answer with a response that matches this regex format:
  #     [a-zA-Z0-9._\%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}
  # --- Receiving response from LLM provider: ---
  #   Here are three potential email addresses for a cupcake company:
  #
  #   1. sweettreats.cupcakes@yummail.com
  #   2. cupcakes.and.love@flourpower.net
  #   3. thecupcakery@gmail.com
  # [1] "sweettreats.cupcakes@yummail.com" "cupcakes.and.love@flourpower.net"
  # "thecupcakery@gmail.com"
}
}
\seealso{
Other pre_built_prompt_wraps: 
\code{\link{add_text}()},
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_as_prompt_wraps: 
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_text}()}
}
\concept{answer_as_prompt_wraps}
\concept{pre_built_prompt_wraps}
