% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubist.R
\name{tidyRules.cubist}
\alias{tidyRules.cubist}
\title{Obtain rules as a tidy tibble from a cubist model}
\usage{
\method{tidyRules}{cubist}(object, ...)
}
\arguments{
\item{object}{Fitted model object with rules}

\item{...}{Other arguments (currently unused)}
}
\value{
A tibble where each row corresponds to a rule. The columns are:
  support, mean, min, max, error, lhs, rhs and committee
}
\description{
Each row corresponds to a rule. A rule can be copied into
  `dplyr::filter` to filter the observations corresponding to a rule
}
\details{
When col_classes argument is missing, an educated guess is made
  about class by parsing the RHS of sub-rule. This might sometimes not lead
  to a parsable rule.

  Optional named arguments:

  \itemize{

  \item language (string, default: "r"): language where the rules are
  parsable. The allowed options is one among: r, python, sql

  }
}
\examples{
data("attrition", package = "modeldata")
attrition <- tibble::as_tibble(attrition)
cols_att <- setdiff(colnames(attrition), c("MonthlyIncome", "Attrition"))

cb_att <-
  Cubist::cubist(x = attrition[, cols_att],y = attrition[["MonthlyIncome"]])
tr_att <- tidyRules(cb_att)
tr_att
}
\author{
Srikanth KS, \email{sri.teach@gmail.com}
}
