% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_methods.R
\name{unite}
\alias{unite}
\title{Unite multiple columns into one by pasting strings together}
\usage{
unite(data, col, ..., sep = "_", remove = TRUE, na.rm = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{col}{The name of the new column, as a string or symbol.

  This argument is passed by expression and supports
  [quasiquotation][rlang::quasiquotation] (you can unquote strings
  and symbols). The name is captured from the expression with
  [rlang::ensym()] (note that this kind of interface where
  symbols do not represent actual objects is now discouraged in the
  tidyverse; we support it here for backward compatibility).}

\item{...}{<[`tidy-select`][tidyr_tidy_select]> Columns to unite}

\item{sep}{Separator to use between values.}

\item{remove}{If `TRUE`, remove input columns from output data frame.}

\item{na.rm}{If `TRUE`, missing values will be remove prior to uniting
each value.}
}
\value{
A tidyseurat objector a tibble depending on input
}
\description{
Convenience function to paste together multiple columns into one.
}
\examples{

pbmc_small \%>\% tidy \%>\% unite("new_col", c(orig.ident, groups)) 


}
\seealso{
[separate()], the complement.
}
