% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_n.R
\name{dt_top_n}
\alias{dt_top_n}
\title{Select top (or bottom) n rows (by value)}
\usage{
dt_top_n(.data, n = 5, wt = NULL, by = NULL)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{n}{Number of rows to return}

\item{wt}{(Optional). The variable to use for ordering. If NULL uses the last column in the data.table.}

\item{by}{\code{list()} of bare column names to group by}
}
\value{
A data.table
}
\description{
This is a wrapper that uses \code{dt[order()]} to select the top or bottom entries in each group, ordered by \code{wt}.
}
\examples{
example_dt <- data.table::data.table(
  x = 1:5,
  y = 6:10,
  z = c(rep("a", 3), rep("b", 2)))

example_dt \%>\%
  dt_top_n(2, wt = y)

example_dt \%>\%
  dt_top_n(2, wt = y, by = z)
}
