% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_helpers.R
\name{starts_with.}
\alias{starts_with.}
\alias{dt_starts_with}
\alias{contains.}
\alias{dt_contains}
\alias{ends_with.}
\alias{dt_ends_with}
\alias{everything.}
\alias{dt_everything}
\alias{any_of.}
\alias{dt_any_of}
\title{Select helpers}
\usage{
starts_with.(match)

dt_starts_with(match)

contains.(match)

dt_contains(match)

ends_with.(match)

dt_ends_with(match)

everything.()

dt_everything()

any_of.(x)

dt_any_of(x)
}
\arguments{
\item{match}{The match for the helper function to use}

\item{x}{Character vector of columns to select}
}
\description{
These functions allow you to select variables based on their names.
\itemize{
\item \code{any_of.()}: Select using a character vector
\item \code{contains.()}: Contains a literal string or regex match
\item \code{everything.()}: Matches all variables
\item \code{starts_with.()}: Starts with a prefix
\item \code{ends_with.()}: Ends with a suffix
}
}
\examples{
example_dt <- data.table::data.table(
  x = 1,
  y = 2,
  double_x = 2,
  double_y = 4)

example_dt \%>\%
  select.(starts_with.("x"))

example_dt \%>\%
  select.(ends_with.("y"))
}
