% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blend_waters.R
\name{blend_waters}
\alias{blend_waters}
\title{Determine blended water quality from multiple waters based on mass balance and acid/base equilibrium}
\usage{
blend_waters(waters, ratios)
}
\arguments{
\item{waters}{Vector of source waters created by \code{\link{define_water}}}

\item{ratios}{Vector of ratios in the same order as waters. (Blend ratios must sum to 1)}
}
\value{
A water class object with blended water quality parameters.
}
\description{
This function takes a vector of waters defined by \code{\link{define_water}}
and a vector of ratios and outputs a new water object with updated ions and pH.
}
\examples{
water1 <- define_water(7, 20, 50)
water2 <- define_water(7.5, 20, 100, tot_nh3 = 2)
blend_waters(c(water1, water2), c(.4, .6))

}
\seealso{
\code{\link{define_water}}
}
