% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get.R
\name{tw_get}
\alias{tw_get}
\title{Return (most) information from a Wikidata item in a tidy format}
\usage{
tw_get(
  id,
  language = "all_available",
  cache = NULL,
  overwrite_cache = FALSE,
  wait = 0,
  include_id = TRUE
)
}
\arguments{
\item{id}{A characther vector, must start with Q, e.g. "Q180099" for the anthropologist Margaret Mead. Can also be a data frame of one row, typically generated with \code{tw_search()} or a combination of \code{tw_search()} and \code{tw_filter_first()}.}

\item{language}{Defaults to "all_available". By default, returns dataset with labels in all available languages. If given, only in the chosen language. For available values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}

\item{include_id}{Logical, defaults to TRUE If TRUE, output includes a column with the wikidata id of the item.}
}
\value{
A data.frame (a tibble) a tibble with three columns, if include_id is set to TRUE (default). A tibble with two columns (property and value) if include_id is set to FALSE.
}
\description{
Return (most) information from a Wikidata item in a tidy format
}
\examples{
tw_get(
  id = "Q180099",
  language = "en"
)
}
