% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_filter.R
\name{tw_filter_people}
\alias{tw_filter_people}
\title{Filter search result and keep only people}
\usage{
tw_filter_people(
  search,
  language = "en",
  limit = 10,
  stop_at_first = TRUE,
  wait = 0
)
}
\arguments{
\item{search}{A data frame generated by \code{tw_search()}, or a search query. If a data frame is given, language and limits are ignore.}

\item{language}{Language to be used for the search.}

\item{limit}{Maximum numbers of responses to be given.}

\item{stop_at_first}{Logical, defaults to TRUE. If TRUE, returns only the first match from the search that satisfies the criteria.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}
}
\value{
A data frame with three columns, \code{id}, \code{label}, and \code{description}; all rows refer to a human being.
}
\description{
A wrapper of \code{tw_filter()} that defaults to keep only "instance of" (P31) "human being" (Q5).
}
\examples{
tw_search("Ruth Benedict")

tw_search("Ruth Benedict") \%>\%
  tw_filter_people()
}
