% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_wikipedia_category_members.R
\name{tw_get_wikipedia_category_members_single}
\alias{tw_get_wikipedia_category_members_single}
\title{Get all Wikidata Q identifiers of all Wikipedia pages that appear in a given page}
\usage{
tw_get_wikipedia_category_members_single(
  url = NULL,
  category = NULL,
  type = "page",
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 1,
  attempts = 5
)
}
\arguments{
\item{url}{Full URL to a Wikipedia category page. If given, title and language can be left empty.}

\item{category}{Title of a Wikipedia category page or final parts of its url. Must include "Category:", or equivalent in other languages. If given, url can be left empty, but language must be provided.}

\item{type}{Defaults to "page", defines which kind of members of a category are returned. Valid values include "page", "file", and "subcat" (for sub-category). Corresponds to \code{cmtype}. For details, see \url{https://www.mediawiki.org/wiki/API:Categorymembers}}

\item{language}{Two-letter language code used to define the Wikipedia version to use. Defaults to language set with \code{tw_set_language()}; if not set, "en". If url given, this can be left empty.}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{cache_connection}{Defaults to NULL. If NULL, and caching is enabled, \code{tidywikidatar} will use a local sqlite database. A custom connection to other databases can be given (see vignette \code{caching} for details).}

\item{disconnect_db}{Defaults to TRUE. If FALSE, leaves the connection to cache open.}

\item{wait}{In seconds, defaults to 1 due to time-outs with frequent queries. Time to wait between queries to the APIs. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}

\item{attempts}{Defaults to 5. Number of times it re-attempts to reach the API before failing.}
}
\value{
A data frame (a tibble) with four columns: \code{wikipedia_title}, \code{wikipedia_id}, \code{wikidata_id}, \code{wikidata_description}.
}
\description{
Get all Wikidata Q identifiers of all Wikipedia pages that appear in a given page
}
\examples{
if (interactive()) {
  tidywikidatar:::tw_get_wikipedia_category_members_single(
    category = "Category:American women anthropologists",
    type = "subcat"
  )

  tidywikidatar:::tw_get_wikipedia_category_members_single(
    category = "Category:Puerto Rican women anthropologists",
    type = "page"
  )
}
}
