% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/national.R
\name{nation}
\alias{nation}
\title{Download a US national boundary shapefile into R}
\usage{
nation(resolution = "5m")
}
\arguments{
\item{resolution}{The resolution of the cartographic boundary file.
       Defaults to '5m'; options include '5m' (1:5 million) and '20m' (1:20 million).}
}
\description{
Download a US national boundary shapefile into R
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

boundary <- nation(resolution = '20m')

leaflet(boundary) \%>\%
   addTiles() \%>\%
   addPolygons()
}
}
\seealso{
Other national cartographic boundary functions: \code{\link{divisions}};
  \code{\link{regions}}
}

