% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{tracts}
\alias{tracts}
\title{Download a Census tracts shapefile into R, and optionally subset by county}
\usage{
tracts(state, county = NULL, cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation.}

\item{county}{The three-digit FIPS code (string) of the county you'd like to
subset for, or a vector of FIPS codes if you desire multiple counties.
Can also be a county name or vector of names.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
tracts file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{defaults to 2016}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Description from the US Census Bureau (see link for source):
Census Tracts are small, relatively permanent statistical subdivisions of
a county or equivalent entity that are updated by local participants prior
to each decennial census as part of the Census Bureau's Participant
Statistical Areas Program. The Census Bureau delineates census tracts in
situations where no local participant existed or where state, local, or
tribal governments declined to participate. The primary purpose of census
tracts is to provide a stable set of geographic units for the presentation
of statistical data.
}
\details{
Census tracts generally have a population size between 1,200 and 8,000 people,
with an optimum size of 4,000 people. A census tract usually covers a
contiguous area; however, the spatial size of census tracts varies widely
depending on the density of settlement.Census tract boundaries are
delineated with the intention of being maintained over a long time so that
statistical comparisons can be made from census to census. Census tracts
occasionally are split due to population growth or merged as a result of
substantial population decline.

Census tract boundaries generally follow visible and identifiable features.
They may follow nonvisible legal boundaries, such as minor civil division
(MCD) or incorporated place boundaries in some states and situations, to
allow for census-tract-to-governmental-unit relationships where the
governmental boundaries tend to remain unchanged between censuses.  State and
county boundaries always are census tract boundaries in the standard census
geographic hierarchy.
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

tarrant <- tracts("TX", "Tarrant", cb = TRUE)

leaflet(tarrant) \%>\%
  addTiles() \%>\%
  addPolygons(popup = ~NAME)
}
}
\seealso{
\url{https://www.census.gov/geo/reference/gtc/gtc_ct.html}

Other general area functions: \code{\link{block_groups}},
  \code{\link{blocks}}, \code{\link{counties}},
  \code{\link{county_subdivisions}}, \code{\link{places}},
  \code{\link{pumas}}, \code{\link{school_districts}},
  \code{\link{states}}, \code{\link{zctas}}
}
