% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{tribal_block_groups}
\alias{tribal_block_groups}
\title{Download a Tribal block groups shapefile into R.}
\usage{
tribal_block_groups(cb = TRUE, year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year; defaults to 2021}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
From the US Census Bureau: "Tribal block groups are subdivisions of a tribal
census tract. Tribal block groups were defined by federally
recognized tribal government officials in the Census Bureau's
Tribal Statistical Areas Program (TSAP) for
the 2010 Census. If a tribal government declined to participate in TSAP, the Census Bureau delineated
tribal block groups on the American Indian reservation and/or off-reservation trust land (ORTL). Tribal
block groups are intended to generally contain between 600 and 3000 persons or between 240 and
1200 housing units. Many American Indian reservations and ORTLs have less than the minimum
population thresholds for more than one tribal block group and in those cases one tribal block group was
delineated that covers the entire American Indian reservation and/or ORTL. Unlike standard block
groups, the cluster of blocks that comprises each tribal block group will not necessarily begin with the
same first number of their 4-character census block number,
but may contain blocks from several different
standard census block groups."  For more information, please see the link provided.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\examples{
\dontrun{
library(tigris)
library(leaflet)

trib <- tribal_block_groups()
leaflet(trib) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5)
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch5GARM.pdf}

Other native/tribal geometries functions: 
\code{\link{alaska_native_regional_corporations}()},
\code{\link{native_areas}()},
\code{\link{tribal_census_tracts}()},
\code{\link{tribal_subdivisions_national}()}
}
\concept{native/tribal geometries functions}
