% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NDRectangle.R
\name{tiledb_ndrectangle_get_range}
\alias{tiledb_ndrectangle_get_range}
\title{Get a range from a \code{tiledb_ndrectangle} object}
\usage{
tiledb_ndrectangle_get_range(ndr, dimname)
}
\arguments{
\item{ndr}{A TileDB NDRectangle object}

\item{dimname}{A character variable with the dimension for which to get a range}
}
\value{
The \code{tiledb_ndrectangle} range as a two-element vector
}
\description{
Get a range from a \code{tiledb_ndrectangle} object
}
\examples{
\dontshow{
ctx <- tiledb_ctx(limitTileDBCores())
}
if (tiledb_version(TRUE) >= "2.26.0") {
  dom <- tiledb_domain(dim = tiledb_dim("d1", c(1L, 100L), type = "INT32"))
  ndr <- tiledb_ndrectangle(dom)
  ndr <- tiledb_ndrectangle_set_range(ndr, "d1", 50, 500)
  tiledb_ndrectangle_get_range(ndr, "d1")
}
}
