% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_collapse.R
\name{group_collapse}
\alias{group_collapse}
\title{Key group information}
\usage{
group_collapse(
  data,
  ...,
  order = TRUE,
  sort = FALSE,
  ascending = TRUE,
  .by = NULL,
  .cols = NULL,
  id = TRUE,
  size = TRUE,
  loc = TRUE,
  start = TRUE,
  end = TRUE,
  .drop = df_group_by_drop_default(data)
)
}
\arguments{
\item{data}{A data frame or vector.}

\item{...}{Additional groups using tidy \code{data-masking} rules. \cr
To specify groups using \code{tidyselect}, simply use the \code{.by} argument.}

\item{order}{Should the groups be ordered?
\bold{THE PHYSICAL ORDER OF THE DATA IS NOT CHANGED.} \cr
When order is \code{TRUE} (the default) the group IDs will be ordered but not sorted.
If \code{FALSE} the order of the group IDs will be based on first appearance.}

\item{sort}{Should the data frame be sorted by the groups?}

\item{ascending}{Should groups be ordered in ascending order?
Default is \code{TRUE} and only applies when \code{order = TRUE}.}

\item{.by}{Alternative way of supplying groups using \code{tidyselect} notation.
This is kept to be consistent with other functions.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{id}{Should group IDs be added? Default is \code{TRUE}.}

\item{size}{Should group sizes be added? Default is \code{TRUE}.}

\item{loc}{Should group locations be added? Default is \code{TRUE}.}

\item{start}{Should group start locations be added? Default is \code{TRUE}.}

\item{end}{Should group end locations be added? Default is \code{TRUE}.}

\item{.drop}{Should unused factor levels be dropped? Default is \code{TRUE}.}
}
\value{
A \code{tibble} of unique groups and an integer ID uniquely identifying each group.
}
\description{
Key group information
}
\details{
\code{group_collapse()} is similar to \code{dplyr::group_data()} but differs in 3 key regards:
\itemize{
\item The output tries to convey as much information about the groups as possible.
By default, like \code{dplyr}, the groups are ordered, but unlike \code{dplyr} they are not
sorted, which conveys information on order-of-first-appearance in the data.
In addition to group locations, group sizes and start indices are returned.
\item There is more flexibility in specifying how the groups are ordered and/or sorted.
\item \code{collapse} is used to obtain the grouping structure, which is very fast.
}

There are 3 ways to specify the groups:
\itemize{
\item Using \code{...} which utilises \code{tidy} \code{data-masking}.
\item Using \code{.by} which utilises \code{tidyselect}.
\item Using \code{.cols} which accepts a named character/integer vector.
}
}
\examples{
library(timeplyr)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
iris <- dplyr::as_tibble(iris)
group_collapse(iris) # No groups
group_collapse(iris, Species) # Species groups

iris \%>\%
  group_by(Species) \%>\%
  group_collapse() # Same thing

# Group entire data frame
group_collapse(iris, .by = everything())
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
