% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslice.R
\name{fslice}
\alias{fslice}
\alias{fslice_head}
\alias{fslice_tail}
\alias{fslice_min}
\alias{fslice_max}
\alias{fslice_sample}
\title{Faster \code{dplyr::slice()}}
\usage{
fslice(data, ..., .by = NULL, keep_order = FALSE, sort_groups = TRUE)

fslice_head(
  data,
  ...,
  n,
  prop,
  .by = NULL,
  keep_order = FALSE,
  sort_groups = TRUE
)

fslice_tail(
  data,
  ...,
  n,
  prop,
  .by = NULL,
  keep_order = FALSE,
  sort_groups = TRUE
)

fslice_min(
  data,
  order_by,
  ...,
  n,
  prop,
  .by = NULL,
  with_ties = TRUE,
  na_rm = FALSE,
  keep_order = FALSE,
  sort_groups = TRUE
)

fslice_max(
  data,
  order_by,
  ...,
  n,
  prop,
  .by = NULL,
  with_ties = TRUE,
  na_rm = FALSE,
  keep_order = FALSE,
  sort_groups = TRUE
)

fslice_sample(
  data,
  n,
  replace = FALSE,
  prop,
  .by = NULL,
  keep_order = FALSE,
  sort_groups = TRUE,
  weights = NULL,
  seed = NULL
)
}
\arguments{
\item{data}{Data frame}

\item{...}{See \code{?dplyr::slice} for details.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{keep_order}{Should the sliced data frame be returned in its original order?
The default is \code{FALSE}.}

\item{sort_groups}{If \code{TRUE} (the default) the by-group slices will be
done in order of the sorted groups.
If \code{FALSE} the group order is determined by first-appearance in the data.}

\item{n}{Number of rows.}

\item{prop}{Proportion of rows.}

\item{order_by}{Variables to order by.}

\item{with_ties}{Should ties be kept together? The default is \code{TRUE}.}

\item{na_rm}{Should missing values in \code{fslice_max()} and \code{fslice_min()} be removed?
The default is \code{FALSE}.}

\item{replace}{Should \code{fslice_sample()} sample with or without replacement?
Default is \code{FALSE}, without replacement.}

\item{weights}{Probability weights used in \code{fslice_sample()}.}

\item{seed}{Seed number defining RNG state.
If supplied, this is only applied \bold{locally} within the function
and the seed state isn't retained after sampling.
To clarify, whatever seed state was in place before the function call,
is restored to ensure seed continuity.
If left \code{NULL} (the default), then the seed is never modified.}
}
\value{
A \code{data.frame} of specified rows.
}
\description{
When there are lots of groups, the \code{fslice()} functions are much faster.
}
\details{
\code{fslice()} and friends allow for more flexibility in how you order the by-group slicing. \cr
Furthermore, you can control whether the returned data frame is sliced in
the order of the supplied row indices, or whether the
original order is retained (like \code{dplyr::filter()}).

In \code{fslice()}, when \code{length(n) == 1}, an optimised method is implemented
that internally uses \code{list_subset()}, a fast function for extracting
single elements from single-level lists that contain vectors of the same
type, e.g. integer.

\code{fslice_head()} and \code{fslice_tail()} are very fast with large numbers of groups.

\code{fslice_sample()} is arguably more intuitive as it by default
resamples each entire group without replacement, without having to specify a
maximum group size like in \code{dplyr::slice_sample()}.
}
\examples{
library(timeplyr)
library(dplyr)
library(nycflights13)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
flights <- flights \%>\%
  group_by(origin, dest)

# First row repeated for each group
flights \%>\%
  fslice(1, 1)
# First row per group
flights \%>\%
  fslice_head(n = 1)
# Last row per group
flights \%>\%
  fslice_tail(n = 1)
# Earliest flight per group
flights \%>\%
  fslice_min(time_hour, with_ties = FALSE)
# Last flight per group
flights \%>\%
  fslice_max(time_hour, with_ties = FALSE)
# Random sample without replacement by group
# (or stratified random sampling)
flights \%>\%
  fslice_sample()
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
