% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_gcd_diff.R
\name{time_gcd_diff}
\alias{time_gcd_diff}
\title{Fast greatest common divisor of time differences}
\usage{
time_gcd_diff(
  x,
  time_by = NULL,
  time_type = getOption("timeplyr.time_type", "auto"),
  tol = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{x}{Time variable. \cr
Can be a \code{Date}, \code{POSIXt}, \code{numeric}, \code{integer}, \code{yearmon}, or \code{yearqtr}.}

\item{time_by}{Time unit. \cr
Must be one of the following:
\itemize{
\item string, specifying either the unit or the number and unit, e.g
\code{time_by = "days"} or \code{time_by = "2 weeks"}
\item named list of length one, the unit being the name, and
the number the value of the list, e.g. \code{list("days" = 7)}.
For the vectorized time functions, you can supply multiple values,
e.g. \code{list("days" = 1:10)}.
\item Numeric vector. If time_by is a numeric vector and x is not a date/datetime,
then arithmetic is used, e.g \code{time_by = 1}.
}}

\item{time_type}{If "auto", \code{periods} are used if \code{x} is a Date and
durations are used if \code{x} is a datetime.
Otherwise numeric differences are calculated.}

\item{tol}{Numeric tolerance for gcd algorithm.}
}
\value{
A list of length 1.
}
\description{
Fast greatest common divisor of time differences
}
\examples{
library(timeplyr)
library(lubridate)
library(cppdoubles)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
time_gcd_diff(1:10)
time_gcd_diff(seq(0, 1, 0.2))

time_gcd_diff(time_seq(today(), today() + 100, time_by = "3 days"))
time_gcd_diff(time_seq(now(), len = 10^2, time_by = "125 seconds"))

# Monthly gcd using lubridate periods
quarter_seq <- time_seq(today(), len = 24, time_by = months(4))
time_gcd_diff(quarter_seq, time_by = months(1), time_type = "period")
time_gcd_diff(quarter_seq, time_by = "months", time_type = "duration")

# Detects monthly granularity
double_equal(time_gcd_diff(as.vector(time(AirPassengers))), 1/12)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
