% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storeListChunkWise.R
\name{storeListChunkWise}
\alias{storeListChunkWise}
\title{Store a List of Time Series Chunk Wise to Avoid Memory Problem}
\usage{
storeListChunkWise(series, con, li = NULL, tbl = "timeseries_main",
  md_unlocal = "meta_data_unlocalized", overwrite = T, chunksize = 10000,
  schema = "timeseries", show_progress = FALSE)
}
\arguments{
\item{series}{character name of a time series, S3 class ts. When used with lists it is convenient to set series to names(li). Note that the series name needs to be unique in the database!}

\item{con}{a PostgreSQL connection object.}

\item{li}{list of time series. Defaults to NULL to no break legacy calls that use lookup environments.}

\item{tbl}{character string denoting the name of the main time series table in the PostgreSQL database.}

\item{md_unlocal}{character string denoting the name of the table that holds unlocalized meta information.}

\item{overwrite}{logical should existing records (same primary key) be overwritten? Defaults to TRUE.}

\item{chunksize}{integer number of chunks. Defaults to chunks of 10K.}

\item{schema}{SQL schema name. Defaults to timeseries.}

\item{show_progress}{If TRUE, storeListChunkWise will print a progress indicator to the console. Default FALSE.}
}
\description{
This function is a wrapper around \code{\link{storeTimeSeries}}. It is used to split large lists of time series
according to memory limitations. This function uses INSERT INTO instead of the more convenient dbWritetable for performance reasons. DO NOT USE THIS FUNCTIONS IN LOOPS OR LAPPLY! This function can handle a set of time series on its own and is much faster than looping over a list. Non-unique primary keys are overwritten !
}
\author{
Matthias Bannert, Gabriel Bucur
}
