% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-tk_augment_differences.R
\name{tk_augment_differences}
\alias{tk_augment_differences}
\title{Add many differenced columns to the data}
\usage{
tk_augment_differences(
  .data,
  .value,
  .lags = 1,
  .differences = 1,
  .log = FALSE,
  .names = "auto"
)
}
\arguments{
\item{.data}{A tibble.}

\item{.value}{A column to have a difference transformation applied}

\item{.lags}{One or more lags for the difference(s)}

\item{.differences}{The number of differences to apply.}

\item{.log}{If TRUE, applies log-differences.}

\item{.names}{A vector of names for the new columns. Must be of same length as the
number of output columns. Use "auto" to automatically rename the columns.}
}
\value{
Returns a \code{tibble} object describing the timeseries.
}
\description{
A handy function for adding multiple lagged difference values to a data frame.
Works with \code{dplyr} groups too.
}
\details{
\strong{Benefits}

This is a scalable function that is:
\itemize{
\item Designed to work with grouped data using \code{dplyr::group_by()}
\item Add multiple differences by adding a sequence of differences using
the \code{.lags} argument (e.g. \code{lags = 1:20})
}
}
\examples{
library(tidyverse)
library(timetk)

m4_monthly \%>\%
    group_by(id) \%>\%
    tk_augment_differences(value, .lags = 1:20)

}
\seealso{
Augment Operations:
\itemize{
\item \code{\link[=tk_augment_timeseries_signature]{tk_augment_timeseries_signature()}} - Group-wise augmentation of timestamp features
\item \code{\link[=tk_augment_holiday_signature]{tk_augment_holiday_signature()}} - Group-wise augmentation of holiday features
\item \code{\link[=tk_augment_roll_apply]{tk_augment_roll_apply()}} - Group-wise augmentation of rolling functions
\item \code{\link[=tk_augment_lags]{tk_augment_lags()}} - Group-wise augmentation of lagged data
\item \code{\link[=tk_augment_differences]{tk_augment_differences()}} - Group-wise augmentation of differenced data
\item \code{\link[=tk_augment_fourier]{tk_augment_fourier()}} - Group-wise augmentation of fourier series
}

Underlying Function:
\itemize{
\item \code{\link[=diff_vec]{diff_vec()}} - Underlying function that powers \code{tk_augment_differences()}
}
}
