% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/binarizeDrugTargets.R
\name{binarizeDrugTargets}
\alias{binarizeDrugTargets}
\title{Binarize the drug target profile data}
\usage{
binarizeDrugTargets(profile, method = "universal", threshold = "100nM")
}
\arguments{
\item{profile}{a matrix with non-binary entries. The rows are drugs and the columns are targets.}

\item{method}{a string to specify the methods used for binarizing the data. When it is "universal", an
universal threshold is used. In such case, another parameter threshold can only be one of "100nM", "1000nM",
and "10000nM". When it is "drug-specific", the threshold used for binarization depends on each drug and
the parameter threshold can be only one of "10fold", "50fold", and "100fold".}

\item{threshold}{a string to specify the threshold.}
}
\value{
A matrix contains the binarized drug target data.
}
\description{
A function for binarizing the drug target profile data.
}
\examples{
data(davis)
profile<-binarizeDrugTargets(davis, method="drug-specific", threshold="50fold")
}
\author{
Jing Tang \email{jing.tang@helsinki.fi}
}

