% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{conditional_gmrf}
\alias{conditional_gmrf}
\title{Conditional simulation from a GMRF}
\usage{
conditional_gmrf(
  Q,
  observed_idx,
  x_obs,
  n_sims = 1,
  what = c("simulate", "predict")
)
}
\arguments{
\item{Q}{precision for a zero-centered GMRF.}

\item{observed_idx}{integer vector listing rows of \code{Q} corresponding to
fixed measurements}

\item{x_obs}{numeric vector with fixed values for indices \code{observed_idx}}

\item{n_sims}{integer listing number of simulated values}

\item{what}{Whether to simulate from the conditional GMRF, or predict the mean
and precision}
}
\value{
A matrix with \code{n_sims} columns and a row for every row of \code{Q} not in
\code{observed_idx}, with simulations for those rows
}
\description{
Generates samples from a Gaussian Markov random field (GMRF) conditional upon
fixed values for some elements.
}
