% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_tcga_group_trans_exp.R
\name{trans_exp}
\alias{trans_exp}
\title{trans_exp}
\usage{
trans_exp(exp, mrna_only = FALSE, lncrna_only = FALSE, gtex = FALSE)
}
\arguments{
\item{exp}{TCGA or TCGA_Gtex expression set from gdc or xena}

\item{mrna_only}{only keep mrna rows in result}

\item{lncrna_only}{only keep lncrna rows in result}

\item{gtex}{logical,whether including Gtex data}
}
\value{
a transformed expression set with symbol
}
\description{
transform rownames of TCGA or TCGA_Gtex expression set from gdc or xena,from ensembl id to gene symbol
}
\examples{
exp = matrix(rnorm(1000),ncol = 10)
rownames(exp) = sample(mRNA_annov23$gene_id,100)
colnames(exp) = c(paste0("TCGA",1:5),paste0("GTEX",1:5))
k  = trans_exp(exp)
}
\seealso{
\code{\link{trans_array}}
}
\author{
Xiaojie Sun
}
