% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_tt.R
\name{theme_tt}
\alias{theme_tt}
\title{Themes for \code{tinytable}}
\usage{
theme_tt(x, theme, ...)
}
\arguments{
\item{x}{A \code{tinytable} object}

\item{theme}{String. Name of the theme to apply. One of:
\itemize{
\item "grid": Vertical and horizontal rules around each cell.
\item "void": No rules
\item "bootstrap": Similar appearance to the default Bootstrap theme in HTML
\item "striped": Grey stripes on alternating rows
\item "tabular": No table environment (LaTeX) or Javascript/CSS (HTML)
\item "resize": Scale a LaTeX \code{tinytable} to fit the \code{width} argument.
\item "multipage": Long tables continue on the next page (LaTeX only)
\item "placement": Position of the table environment (LaTeX)
}}

\item{...}{Additional arguments passed the themeing function. See the "Arguments" section below for a list of supported arguments for each theme.}
}
\value{
A modified \code{tinytable} object
}
\description{
A theme is a function which applies a collection of transformations to a \code{tinytable} object. Whereas the other \code{tinytable} functions such as \code{format_tt()} and \code{style_tt()} aim to be output-agnostic, themes can be output-specific, only applying to LaTeX, HTML, or Typst, as needed.

Each theme can have specific arguments, which are passed to the \code{theme_tt()} function. See the "Arguments" section below.
}
\section{Arguments}{


resize
\itemize{
\item \code{width}: A numeric value between 0.01 and 1, representing the proportion of the line width to use
\item \code{direction}: "down", "up", "both" A string indicating if the table should be scaled in one direction. For example, "down" will only resize the table if it exceeds \verb{\\linewidth}
}

multipage
\itemize{
\item \code{rowhead}: Non-negative integer. The number of header rows to repeat on each page.
\item \code{rowfoot}: Non-negative integer. The number of footer rows to repeat on each page.
}

placement
\itemize{
\item \code{latex_float}: String to insert in square brackets after the LaTeX table environment, ex: "H", "htbp". The default value is controlled by a global option:
\itemize{
\item \code{options("tinytable_theme_placement_latex_float" = "H")}
}
}
}

\examples{
library(tinytable)

x <- mtcars[1:4, 1:4]

# equivalent calls
tt(x, theme = "striped")

tt(x) |> theme_tt("striped")

# resize w/ argument
x <- cbind(mtcars[1:10,], mtcars[1:10,])
tt(x) |>
  theme_tt("resize", width = .9) |>
  print("latex")

}
