% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_raster}
\alias{tm_raster}
\title{Draw a raster}
\usage{
tm_raster(col = "grey70", alpha = NA, palette = NULL, n = 5,
  style = "pretty", breaks = NULL, labels = NULL,
  auto.palette.mapping = TRUE, contrast = 1, max.categories = 12,
  colorNA = NA, textNA = "Missing", text_separator = "to",
  text_less_than = "Less than", text_or_more = "or more", title = NA,
  legend.is.portrait = TRUE, legend.hist = FALSE, legend.hist.title = NA,
  legend.z = NA, legend.hist.z = NA)
}
\arguments{
\item{col}{either a single color value or the name of a data variable that is contained in \code{shp}. In the latter case, either the data variable contains color values, or values (numeric or categorical) that will be depicted by a color palette (see \code{palette}. In the latter case, a choropleth is drawn.}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{palette}{palette name. See \code{RColorBrewer::display.brewer.all()} for options. Use a \code{"-"} as prefix to reverse the palette. By default, \code{"RdYlGn"} is taken for numeric variables and \code{"Dark2"} for categorical variables.}

\item{n}{preferred number of classes (in case \code{col} is a numeric variable)}

\item{style}{method to cut the color scale (in case \code{col} is a numeric variable): e.g. "fixed", "equal", "pretty", "quantile", or "kmeans". See the details in \code{\link[classInt:classIntervals]{classIntervals}}.}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values.}

\item{contrast}{vector of two numbers that determine the range that is used for sequential and diverging palettes (applicable when \code{auto.palette.mapping=TRUE}). Both numbers should be between 0 and 1. The first number determines where the palette begins, and the second number where it ends. For sequential palettes, 0 means the brightest color, and 1 the darkest color. For diverging palettes, 0 means the middle color, and 1 both extremes. If only one number is provided, this number is interpreted as the endpoint (with 0 taken as the start).}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories}, then levels are combined.}

\item{colorNA}{color used for missing values}

\item{textNA}{text used for missing values. Use \code{NA} to omit text for missing values in the legend}

\item{text_separator}{Character string to use to separate numbers in the legend (default: "to").}

\item{text_less_than}{Character string to use to translate "Less than" (which is the default).}

\item{text_or_more}{Character string to use to translate "or more" (which is the default).}

\item{title}{title of the legend element}

\item{legend.is.portrait}{logical that determines whether the legend is in portrait mode (\code{TRUE}) or landscape (\code{FALSE})}

\item{legend.hist}{logical that determines whether a histogram is shown}

\item{legend.hist.title}{title for the histogram. By default, one title is used for both the histogram and the normal legend.}

\item{legend.z}{index value that determines the position of the legend element with respect to other legend elements. The legend elements are stacked according to their z values. The legend element with the lowest z value is placed on top.}

\item{legend.hist.z}{index value that determines the position of the histogram legend element}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that draws a raster. Either a fixed color is used, or a color palette is mapped to a data variable. By default, a divering color palette is used for numeric variables and a qualitative palette for categorical variables.
}
\examples{
data(land)
data(World)

pal20 <- c("#003200", "#3C9600", "#006E00", "#556E19", "#00C800", "#8CBE8C",
		     "#467864", "#B4E664", "#9BC832", "#EBFF64", "#F06432", "#9132E6",
		     "#E664E6", "#9B82E6", "#B4FEF0", "#646464", "#C8C8C8", "#FF0000",
		     "#FFFFFF", "#5ADCDC")
tm_shape(land) +
    tm_raster("cover", max.categories = 20, palette=pal20, title="Global Land Cover") + 
tm_layout_World(inner.margins=0, legend.position = c("left","bottom"))

pal8 <- c("#33A02C", "#B2DF8A", "#FDBF6F", "#1F78B4", "#999999", "#E31A1C", "#E6E6E6", "#A6CEE3")
tm_shape(land, ylim = c(-88,88), relative=FALSE) +
    tm_raster("cover_cls", palette = pal8, title="Global Land Cover") +
tm_shape(World) +
    tm_borders() +
tm_layout_World(inner.margins=0,
    legend.position = c("left","bottom"),
    legend.bg.color = "white", legend.bg.alpha=.2, 
    legend.frame="gray50", legend.width=.2)

tm_shape(land, ylim = c(-88,88), relative=FALSE) +
    tm_raster("trees", palette = "Greens", title="Percent Tree Cover") +
tm_shape(World) +
    tm_borders() +
tm_layout(inner.margins=0, 
    legend.position = c("left","bottom"), bg.color="lightblue")

tm_shape(land) +
    tm_raster("black") +
    tm_facets(by="cover_cls") +
tm_layout(inner.margins=0, 
    title.position = c("left", "bottom"), title.bg.color="gray80")
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

