% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\docType{data}
\name{World}
\alias{World}
\alias{NLD_prov}
\alias{NLD_muni}
\title{World and Netherlands map}
\source{
\url{http://www.naturalearthdata.com} for \code{World}

\url{http://www.happyplanetindex.org} for \code{World}

\url{http://www.cbs.nl} for \code{NLD_prov} and \code{NLD_muni}.
}
\usage{
data(World)

data(NLD_prov)

data(NLD_muni)
}
\description{
Maps of the world and the Netherlands (province and municipality level), class \code{\link[sf:sf]{sf}}
}
\details{
The default projections for these maps are Eckhart IV (World) and Rijksdriehoekstelsel (Netherlands). See below. To change the projection, use \code{\link[tmaptools:set_projection]{set_projection}}. Alternatively, the projection can be changed temporarily for plotting purposes by using the projection argument of \code{\link{tm_shape}} (or \code{\link{qtm}}).

\code{World} World map. The default projection for this world map is Eckhart IV since area sizes are preserved, which is a very important property for choropleths.

\code{NLD_prov} and \code{NLD_muni}, maps of the Netherlands at province and municipality level of 2013. The used projection is the Rijksdriehoekstelsel projection. \strong{Important:} publication of these maps is only allowed when cited to Statistics Netherlands (CBS) and Kadaster Nederland as source.
}
\references{
Statistics Netherlands (2014), The Hague/Heerlen, Netherlands, \url{http://www.cbs.nl}.

Kadaster, the Netherlands' Cadastre, Land Registry, and Mapping Agency (2014), Apeldoorn, Netherlands, \url{http://www.kadaster.nl}.
}
