% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_animation.R
\name{tmap_animation}
\alias{tmap_animation}
\title{Create animation}
\usage{
tmap_animation(tm, filename = "animation.gif", width = NA,
  height = NA, dpi = NA, delay = 40, loop = TRUE,
  restart.delay = 0)
}
\arguments{
\item{tm}{tmap object. In order to create a series of tmap plots, which will be the frames of the animation, it is important to set nrow and ncol in \code{\link{tm_facets}}, for otherwise a small multiples plot is generated. Commonly, where one map is shown at a time, both nrow and ncol are set to 1.}

\item{filename}{filename of the video (should be a .gif or .mpg file)}

\item{width}{width of the animation file (in pixels)}

\item{height}{height of the animation file (in pixels)}

\item{dpi}{dots per inch. Only applicable for raster graphics. By default 300, but this can be set with the option \code{output.dpi} in \code{\link{tmap_options}}.}

\item{delay}{delay time between images (in 1/100th of a second)}

\item{loop}{logical that determined whether the animation is looped, or an integer value that determines how many times the animation is looped.}

\item{restart.delay}{delay time between the loops (in 1/100th of a second)}
}
\description{
Create a gif or mpeg animation from a tmap plot. The free tool ImageMagick is required.
}
\note{
Not only tmap plots are supported, but any series of R plots.
}
\examples{
\dontrun{
data(NLD_prov)

m1 <- tm_shape(NLD_prov) + 
	      tm_polygons("yellow") +
	  tm_facets(along = "name")

tmap_animation(m1, filename="Dutch_provinces.gif", width=800, delay=40)

data(World, metro)

m2 <- tm_shape(World, simplify = 0.5) +
          tm_fill() +
      tm_shape(metro) + 
          tm_bubbles(size = paste0("pop", seq(1970, 2030, by=10)),
          		   col = "purple",
          		   border.col = "black", border.alpha = .5,
          		   scale = 2) +
      tm_facets(free.scales.symbol.size = FALSE, nrow=1,ncol=1) + 
      tm_format("World", scale=.5)

tmap_animation(m2, filename="World population.gif", width=1200, delay=100)
}
}
\concept{animation}
