% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_shape.R
\name{read_shape}
\alias{read_shape}
\title{Read shape file}
\usage{
read_shape(file, current.projection = NULL, as.sf = FALSE, ...)
}
\arguments{
\item{file}{a shape file name (including directory)}

\item{current.projection}{the current projection of the shape object, if it is missing in the shape file. See \code{\link{get_proj4}} for options. Use \code{\link{set_projection}} to reproject the shape object.}

\item{as.sf}{should the shape be returned as an \code{sf} object?}

\item{...}{other parameters, such as \code{stringsAsFactors}, are passed on to \code{\link[rgdal:readOGR]{readOGR}}}
}
\value{
shape object
}
\description{
Read an ESRI shape file. Optionally, set the current projection if it is missing.
}
\details{
This function is a convenient wrapper of rgdal's \code{\link[rgdal:readOGR]{readOGR}}. It is possible to set the current projection, if it is undefined in the shape file. If a reprojection is required, use \code{\link{set_projection}}.

For the Netherlands: often, the Dutch Rijksdriehoekstelsel (Dutch National Grid) projection is provided in the shape file without proper datum shift parameters to wgs84. This functions automatically adds these parameters. See \url{http://www.qgis.nl/2011/12/05/epsg28992-of-rijksdriehoekstelsel-verschuiving/} (in Dutch) for details.
}

