% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_GPX.R
\name{read_GPX}
\alias{read_GPX}
\title{Read GPX file}
\usage{
read_GPX(
  file,
  layers = c("waypoints", "routes", "tracks", "route_points", "track_points"),
  remove.empty.layers = TRUE,
  as.sf = TRUE
)
}
\arguments{
\item{file}{a GPX filename (including directory)}

\item{layers}{vector of GPX layers. Possible options are \code{"waypoints"}, \code{"tracks"}, \code{"routes"}, \code{"track_points"}, \code{"route_points"}. By dedault, all those layers are read.}

\item{remove.empty.layers}{should empty layers (i.e. with 0 features) be removed from the list?}

\item{as.sf}{not used anymore}
}
\value{
a list of sf objects, one for each layer
}
\description{
Read a GPX file. By default, it reads all possible GPX layers, and only returns shapes for layers that have any features.
}
\details{
Note that this function returns \code{\link[sf:sf]{sf}} objects, but still uses methods from sp and rgdal internally.
}
