% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tmlenet-package.R
\docType{data}
\name{df_netKmax6}
\alias{df_netKmax6}
\title{An example of a row-dependent dataset with known network of at most 6 friends.}
\format{A data frame with 1,000 dependent observations (rows) and 6 variables:
\describe{
  \item{IDs}{unique observation identifier}
  \item{W1}{categorical baseline covariate (independent), range 0-5}
  \item{W2}{binary baseline covariate (independent)}
  \item{W3}{binary baseline covariate (independent)}
  \item{A}{binary exposure that depends on unit's baseline covariate values, as well as the
     baseline covariate values of observations in the friend network \code{Net_str}}
  \item{Y}{binary outcome that depends on unit's baseline covariate value and exposure, as well as the
     baseline covariate values and exposures of observations in the friend network \code{Net_str}}
  \item{nFriends}{number of friends for each observation (row), range 0-6}
  \item{Net_str}{a vector of strings, where for each observation its a string of space separated friend IDs (this can
     be either observation IDs or just space separated friend row numbers)}
}}
\usage{
data(df_netKmax6)
}
\description{
Simulated dataset containing 3 measured i.i.d. baseline covariates (\code{W1}, \code{W2}, \code{W3}), dependent binary exposure (\code{A})
 and dependent binary binary outcome (\code{Y}), along with a known network of friends encoded by strings on space separated
 friend IDs in \code{Net_str}.
 The baseline covariates (\code{W1},\code{W2},\code{W3}) were sampled as i.i.d.,
 while the exposure value of \code{A} for each observation \code{i} was sampled
 conditionally on the values of \code{i}'s baseline covariates (\code{W1[i]} \code{W2[i]}, \code{W3[i]}),
 as well as the baseline covariate values of \code{i}'s friends in \code{Net_str}.
 Similarly, the binary outcome \code{Y} for each observation was generated conditionally on \code{i}'s
 exposure and baseline covariates values in (\code{W1[i]},\code{W2[i]},\code{W3[i]},\code{A[i]}),
 as well as the values of exposures and baseline covariates of \code{i}'s friends in \code{Net_str}.
 Individual variables are described below.
}
\keyword{datasets}

