% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes2.R
\name{makeTmodGS}
\alias{makeTmodGS}
\alias{makeTmod}
\alias{as_tmodGS}
\alias{print.tmodGS}
\alias{length.tmodGS}
\alias{[.tmodGS}
\alias{[.tmod}
\title{S3 class for tmod gene set collections}
\usage{
makeTmodGS(gs2gene, gs = NULL, weights = NULL, info = NULL)

makeTmod(modules, modules2genes, genes2modules = NULL, genes = NULL)

as_tmodGS(x, check_sanity = FALSE)

\method{print}{tmodGS}(x, ...)

\method{length}{tmodGS}(x)

\method{[}{tmodGS}(x, i)

\method{[}{tmod}(x, i)
}
\arguments{
\item{gs2gene, modules2genes}{A list with module IDs as names. Each member of the list is a character vector with IDs of genes contained in that module}

\item{gs, modules}{[Optional] A data frame with at least columns ID and Title}

\item{weights}{[Optional] a named numeric vector of weights for each gene set}

\item{info}{[Optional] a list containing meta-information about the gene set collection}

\item{genes2modules, genes}{Ignored}

\item{x}{a tmodGS or tmod object}

\item{check_sanity}{whether the tmodGS object should be tested for correctness}

\item{...}{further arguments passed to `print()`}

\item{i}{indices specifying elements to extract or replace}
}
\description{
S3 class for tmod gene set collections
}
\details{
An object of class tmod contains the gene set annotations (`tmod$gs`), 
a character vector of gene identifiers (`tmod$gv`)
and a mapping between gene sets and gene identifiers (`tmod$gs2gv`).
Optionally, a vector of numeric weights of the same length as `gs2gv` may
be provided (`tmod$weights`).

Furthermore, it may contain additional information about the gene set
(`tmod$info`).

`tmod$gs` is a data frame which must contain the column "ID". Additional
optional columns `Title` and `Description` are recognized by some
functions. Any further columns may contain additional information on the
gene sets. The number of rows of that data frame is equal to the number
of gene sets in a gene set collection.

Each element of the tmod$g2m list corresponds to the respective row of
the `tmod$gs` data frame. Each element is an integer vector containing
the positions of the gene identifiers in the `tmod$gv` character vector.

Objects of class tmodGS should be constructed 
by calling the function makeTmodGS(). This function check the validity and
consistency of the provided objects.

The makeTmod function remains for compatibility with previous versions
of the package. It produces the objects of the new class tmodGS,
however.

See the package vignette for more on constructing custom module sets.
}
\examples{
# A minimal example
gs <- data.frame(ID=letters[1:3], Title=LETTERS[1:3])
gs2gv <- list(a=c("g1", "g2"), b=c("g3", "g4"), c=c("g1", "g2", "g4"))
mymset <- makeTmodGS(gs2gene=gs2gv, gs=gs)
str(mymset)
}
\seealso{
tmod-data
}
