% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna}
\alias{plot.tna}
\title{Plot a Transition Network Analysis Model}
\usage{
\method{plot}{tna}(
  x,
  labels,
  colors,
  pie,
  edge.labels = TRUE,
  layout = "circle",
  layout_args = list(),
  mar = rep(5, 4),
  theme = "colorblind",
  ...
)
}
\arguments{
\item{x}{A \code{tna} object from \code{\link[=tna]{tna()}}.}

\item{labels}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{colors}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{pie}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{edge.labels}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{layout}{One of the following:
\itemize{
\item A \code{character} string describing a \code{qgraph} layout.
\item A \code{matrix} of node positions to use, with a row for each node and
\code{x} and \code{y} columns for the node positions.
\item A layout function from \code{igraph}.
}}

\item{layout_args}{A \code{list} of arguments to pass to the \code{igraph} layout
function when \code{layout} is a function.}

\item{mar}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{theme}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{...}{Additional arguments passed to \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
}
\value{
A \code{qgraph} plot of the transition network.
}
\description{
This function plots a transition network analysis (TNA) model using
the \code{qgraph} package. The nodes in the graph represent states, with node
sizes corresponding to initial state probabilities. Edge labels represent
the edge weights of the network.
}
\examples{
model <- tna(engagement)
plot(model)

}
\seealso{
Core functions
\code{\link{build_model}()},
\code{\link{centralities}()},
\code{\link{plot.tna_centralities}()},
\code{\link{plot_compare}()}
}
\concept{core}
