% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_.R
\name{sp_defaults}
\alias{sp_defaults}
\title{Set default Sharepoint settings for a session}
\usage{
sp_defaults(site = NULL, drive = NULL)
}
\arguments{
\item{site}{Site identifier. Can be the site_name, site_url, site_id, or an ms_site object. If not provided, uses the current stored default site if it exists.}

\item{drive}{Name of the drive within the site. If site is provided but drive is not, uses the first drive of the provided site. If neither is provided, uses the stored default drive if it exists.}
}
\value{
No return value
}
\description{
Sets default site and drive for using the other \verb{sp_*()} functions.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set default site
sp_defaults(site = "Data Analytics")

# List drives from the default site
sp_list_drives()

# List files/folders in the default site and drive.
# Since no default drive was added, uses the first listed drive for the site.
sp_list()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sp_list]{sp_list()}}, \code{\link[=sp_read]{sp_read()}}, \code{\link[=sp_write]{sp_write()}}, \code{\link[=sp_site]{sp_site()}}, \code{\link[=sp_drive]{sp_drive()}}
}
