% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating.R
\name{bart_factors}
\alias{bart_factors}
\title{Get Four Factor Statistics}
\usage{
bart_factors(
  year = current_season(),
  venue = "all",
  type = "all",
  quad = "4",
  top = 0,
  start = NULL,
  end = NULL
)
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{venue}{Filters by venue; defaults to `all`.}

\item{type}{Filters by game type; defaults to `all`.}

\item{quad}{Filters by quadrant level; defaults to `4`.}

\item{top}{Filters by opponent T-Rank position; defaults to NULL (all).}

\item{start}{Filters by start date; defaults to NULL (full season).}

\item{end}{Filters by end date; defaults to NULL (full season).}
}
\value{
Returns a tibble with 22 columns:
\describe{
  \item{\code{team}}{character.}
  \item{\code{conf}}{character.}
  \item{\code{barthag}}{double. The estimation of a team's win probability
  against the average Division 1 team on a neutral court.}
  \item{\code{rec}}{character.}
  \item{\code{wins}}{double.}
  \item{\code{games}}{double.}
  \item{\code{adj_t}}{double.}
  \item{\code{adj_o}}{double.}
  \item{\code{off_efg}}{double.}
  \item{\code{off_to}}{double.}
  \item{\code{off_or}}{double.}
  \item{\code{off_ftr}}{double.}
  \item{\code{adj_d}}{double.}
  \item{\code{def_efg}}{double.}
  \item{\code{def_to}}{double.}
  \item{\code{def_or}}{double.}
  \item{\code{def_ftr}}{double.}
  \item{\code{wab}}{double. The number of wins above or below the expected
  total from a bubble team against the same schedule.}
  \item{\code{year}}{double.}
  \item{\code{venue}}{character. Split supplied to the venue argument.}
  \item{\code{type}}{character. Split supplied to the type argument.}
  \item{\code{top}}{double. Split supplied to the top argument.}
  \item{\code{quad}}{character. Split supplied to the quad argument.}
}
}
\description{
Returns four factor data and team records on a variety of splits, including
date range, quadrant level, opponent ranking, game location, and game type.
}
\details{
For a brief explanation of each factor and its computation, please visit
\href{https://kenpom.com/blog/four-factors/}{KenPom's blog}. Data can be
split on five variables: \describe{ \item{venue}{Splits on game location;
'all', 'home', 'away', 'neutral', and 'road' (away + neutral).}
\item{type}{Splits on game type; 'all', 'nc' (non-conference), 'conf'
(conference), 'reg' (regular season), 'post' (post-season tournaments),
'ncaa' (NCAA tournament).} \item{quad}{Splits by quadrant level; 1-4 with 0
indicating 1-A games.} \item{top}{Splits by opponent T-Rank position,
adjusted for game location.} \item{start/end}{Splits by date range
(YYYYMMDD).}}
}
\examples{
\donttest{bart_factors(quad='3', venue='away', start='20220101')}

}
