% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_game_prediction.R
\name{bart_game_prediction}
\alias{bart_game_prediction}
\title{T-Rank Game Prediction}
\usage{
bart_game_prediction(team = NULL, opp = NULL, date = NULL, location = "N")
}
\arguments{
\item{team}{Team for game}

\item{opp}{Opponent for game}

\item{date}{Date for game; YYYYMMDD format}

\item{location}{Location for game ('N', 'H', or 'A')}
}
\value{
Returns a tibble with eight columns: \describe{
  \item{\code{team}}{character.} \item{\code{date}}{date.}
  \item{\code{location}}{character.} \item{\code{tempo}}{double.}
  \item{\code{ppp}}{double.} \item{\code{pts}}{double.}
  \item{\code{win_per}}{double.} \item{\code{did_win}}{logical.} }
}
\description{
Returns game predictions using Barttorvik's model
}
\details{
Function returns projected score, points per possession, tempo, and win
percentage for a given match-up on a given day
}
\examples{
\donttest{try(bart_game_prediction(team='Duke', opp='North Carolina', date='20220402'))}

}
